#!/bin/sh

# Make sure only root can run our script
if [ "$(id -u)" -ne 0 ]; then
	echo "This script must be run as root."
	exit 1
fi

if [ -f /usr/local/netextender/method ]; then

	method=`cat /usr/local/netextender/method`
	#echo "The existing method file is" $method
	# check if there is NetExtender installed via rpm
	if [ "$method" = "rpm" ]; then
		echo "Found NetExtender has been installed via rpm file."
		echo "Please uninstall NetExtender correctly first."
		exit 1
	# check if there is NetExtender installed via deb
	elif [ "$method" = "deb" ]; then
        echo "Found NetExtender has been installed via deb file."
        echo "Please uninstall NetExtender correctly first."
        exit 1
	# check if there is NetExtender installed via tar
	elif [ "$method" = "tar" ]; then
	    echo "Found NetExtender has been installed via tar file."
		if [ -f /usr/local/netextender/nxuninstall.sh ]; then
			echo "NetExtender has been installed via tar file. Uninstalling first."
			/usr/local/netextender/nxuninstall.sh
		fi
	else
		echo "NetExtender is installed via unknown file."
		echo "Please uninstall NetExtender correctly first."
		exit 1
	fi
fi

# Check if there is any old netextender installed on linux
if [ -f /tmp/netextender.pid ]; then
	echo "Found possible old netextender installed"
        if ! [ -z `pidof netExtender` ]; then
                echo "Killed running netExtender"
                pkill -9 netExtender
        fi

        if ! [ -z `pidof NetExtender.jar` ]; then
                echo "Killed running NetExtender.jar"
                pkill -9 NetExtender.jar
        fi

	rpm -q NetExtender >/dev/null 2>&1
	if [ $? -eq 0 ]; then
		echo "Installation method is rpm"
		rpm -e NetExtender
	else
		echo "Installation method is tar"
		if [ -f /usr/sbin/netExtender ]; then
			echo "Found an old netextender client, trying to uninstall"
			/usr/sbin/netExtender --uninstall
		fi
	fi

	rm -f /tmp/netextender.pid

	if [ -d /home/${SUDO_USER}/.netExtenderCerts ]; then
		echo "Removed /home/${SUDO_USER}/.netExtenderCerts"
		rm -r /home/${SUDO_USER}/.netExtenderCerts
	fi

	if [ -f /home/${SUDO_USER}/.netextender ]; then
		echo "Removed /home/${SUDO_USER}/.netextender"
		rm -f /home/${SUDO_USER}/.netextender
	fi

	if [ -f /home/${SUDO_USER}/.netExtender.log ]; then
		echo "Removed /home/${SUDO_USER}/.netExtender.log"
		rm -f /home/${SUDO_USER}/.netExtender.log
	fi

	if [ -d "/home/${SUDO_USER}/.sonicwall/EPC" ]; then
		echo "Removed /home/${SUDO_USER}/.sonicwall/EPC"
		rm -r /home/${SUDO_USER}/.sonicwall/EPC
	fi
fi

# check if there is any bin running during installation
ps -p 1 | grep systemd >> /dev/null
if [ $? -eq 0 ]; then
	systemctl is-active --quiet NEService && systemctl stop NEService && systemctl disable NEService
fi

nxpid=$(pidof NetExtender)
if ! [ -z ${nxpid} ]; then
        echo "Killed running NetExtender"
        kill ${nxpid}
fi

clipid=$(pidof nxcli)
if ! [ -z ${clipid} ]; then
        echo "Killed running nxcli"
        kill ${clipid}
fi

if ! [ -d /usr/local/netextender ]; then
	echo "Create folder /usr/local/netextender"
	mkdir -p /usr/local/netextender
fi

if [ -f wg ] && ! [ -f /usr/local/netextender/wg ]; then
	echo "Copy wg to /usr/local/netextender"
	cp wg /usr/local/netextender/
fi

if [ -f wg-quick ] && ! [ -f /usr/local/netextender/wg-quick ]; then
	echo "Copy wg-quick to /usr/local/netextender"
	cp wg-quick /usr/local/netextender/
fi

if [ -f wireguard-go ] && ! [ -f /usr/local/netextender/wireguard-go ]; then
	echo "Copy wireguard-go to /usr/local/netextender"
	cp wireguard-go /usr/local/netextender/
fi

if [ -f NEService ] && ! [ -f /usr/local/netextender/NEService ]; then
	echo "Copy NEService to /usr/local/netextender"
	cp NEService /usr/local/netextender/
fi

if ! [ -f /usr/local/netextender/NetExtender ]; then
	ldconfig --version > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		ldconfig -p | grep libwebkit2gtk-4.1 > /dev/null 2>&1
		if [ $? -eq 0 ]; then
			echo "Copy NetExtender_webkit2_41 to /usr/local/netextender"
			cp NetExtender_webkit2_41 /usr/local/netextender/NetExtender
			echo "Copy autoUpgrader_webkit2_41 to /usr/local/netextender"
			cp autoUpgrader_webkit2_41 /usr/local/netextender/autoUpgrader
		else
			echo "Copy NetExtender_webkit2_40 to /usr/local/netextender"
			cp NetExtender_webkit2_40 /usr/local/netextender/NetExtender
			echo "Copy autoUpgrader_webkit2_40 to /usr/local/netextender"
			cp autoUpgrader_webkit2_40 /usr/local/netextender/autoUpgrader
		fi
	else
		echo "Failed to detect libwebkit2gtk version, using libwebkit2gtk0-4.0"
		echo "Copy NetExtender_webkit2_40 to /usr/local/netextender"
		cp NetExtender_webkit2_40 /usr/local/netextender/NetExtender
		echo "Copy autoUpgrader_webkit2_40 to /usr/local/netextender"
		cp autoUpgrader_webkit2_40 /usr/local/netextender/autoUpgrader
	fi
fi

if [ -f nxcli ] && ! [ -f /usr/local/netextender/nxcli ]; then
	echo "Copy nxcli to /usr/local/netextender"
	cp nxcli /usr/local/netextender/
fi

if [ -f uninstall.sh ] && ! [ -f /usr/local/netextender/nxuninstall.sh ]; then
	echo "Copy uninstall.sh to /usr/local/netextender"
	cp uninstall.sh /usr/local/netextender/nxuninstall.sh
fi

if [ -f upgrade.sh ] && ! [ -f /tmp/upgrade.sh ]; then
	echo "Copy upgrade.sh to /tmp"
	cp upgrade.sh /usr/local/netextender/nxupgrade.sh
fi

if [ -f NEService.service ] && ! [ -f /usr/local/netextender/NEService.service ]; then
	echo "Copy NEService.service to /usr/local/netextender"
	cp NEService.service /usr/local/netextender/
fi

if [ -f neservice ] && ! [ -f /usr/local/netextender/neservice ]; then
	echo "Copy neservice to /usr/local/netextender"
	cp neservice /usr/local/netextender/
fi

if [ -d locales ] && ! [ -d /usr/local/netextender/locales ]; then
	echo "Copy locales folder to /usr/local/netextender"
	cp -r locales /usr/local/netextender/
fi

if [ -f com.sonicwall.NetExtender.desktop ] && ! [ -f /usr/local/netextender/com.sonicwall.NetExtender.desktop ]; then
	echo "Copy com.sonicwall.NetExtender.desktop to /usr/local/netextender"
	cp com.sonicwall.NetExtender.desktop /usr/local/netextender/
fi

if [ -f nx-icon.png ] && ! [ -f /usr/local/netextender/nx-icon.png ]; then
	echo "Copy nx-icon.png to /usr/local/netextender"
	cp nx-icon.png /usr/local/netextender/
fi

if [ -f method ]; then
	echo "Copy method to /usr/local/netextender"
	cp method /usr/local/netextender/
fi

if ! [ -x "$(command -v netExtender)" ]; then
	echo "Create symlink from /usr/local/netextender/nxcli to /usr/sbin/netExtender"
	ln -s /usr/local/netextender/nxcli /usr/sbin/netExtender
fi

if ! [ -x "$(command -v nxcli)" ]; then
	echo "Create symlink from /usr/local/netextender/nxcli to /usr/sbin/nxcli"
	ln -s /usr/local/netextender/nxcli /usr/sbin/nxcli
fi

if ! [ -x "$(command -v resolvconf)" ] && [ -x "$(command -v resolvectl)" ]; then
	resolvectl=$(command -v resolvectl)
	echo "Create symlink from ${resolvectl} to /usr/sbin/resolvconf"
	ln -s ${resolvectl} /usr/bin/resolvconf
fi

# check if wg is installed
#if ! [ -x "$(command -v wg)" ]; then
#	echo "Create symlink from /usr/local/netextender/wg to  /usr/bin/wg"
#	ln -s /usr/local/netextender/wg /usr/bin/wg
#fi

# check if wg-quick is installed
#if ! [ -x "$(command -v wg-quick)" ]; then
#	echo "Create symlink from /usr/local/netextender/wg-quick to /usr/bin/wg-quick"
#	ln -s /usr/local/netextender/wg-quick /usr/bin/wg-quick
#fi

# check if wireguard-go is installed
#if ! [ -x "$(command -v wireguard-go)" ]; then
#	echo "Create symlink from /usr/local/netextender/wireguard-go to /usr/bin/wireguard-go"
#	ln -s /usr/local/netextender/wireguard-go /usr/bin/wireguard-go
#fi

# Install service
ps -p 1 | grep systemd >> /dev/null
if [ $? -eq 0 ]; then
	echo "Install NEService with systemd"
	chmod 640 NEService.service
#if ! [ -L /usr/local/bin/SonicWallNxService ]; then
#	echo "Create symlink from /usr/local/netextender/SonicWallNxService to /usr/local/bin/SonicWallNxService"
#	ln -s /usr/local/netextender/SonicWallNxService /usr/local/bin/SonicWallNxService
#fi
	cp NEService.service /etc/systemd/system/
	systemctl daemon-reload
	systemctl enable NEService
	systemctl start NEService
	echo "Start NEService successfully"
fi

ps -p 1 | grep init >> /dev/null
if [ $? -eq 0 ]; then
	echo "Install service with sysvinit"
	chmod +x neservice
	cp neservice /etc/init.d/
	update-rc.d neservice defaults
	/etc/init.d/neservice start
	echo "Start NEService successfully"
fi

# nx cli
#if ! [ -x "$(command -v nx)" ]; then
#	echo "Create symlink from /usr/local/netextender/nx to /usr/local/bin/nx"
#	ln -s /usr/local/netextender/nx /usr/local/bin/nx
#fi

# desktop file
if [ -f /usr/local/netextender/com.sonicwall.NetExtender.desktop ] && ! [ -f /usr/share/applications/com.sonicwall.NetExtender.desktop ]; then
	echo "Copy desktop file from /usr/local/netextender/com.sonicwall.NetExtender.desktop to /usr/share/applications/com.sonicwall.NetExtender.desktop"
	cp /usr/local/netextender/com.sonicwall.NetExtender.desktop /usr/share/applications/com.sonicwall.NetExtender.desktop
fi

echo "Install SonicWall Netextender successfully"
exit 0
